IF NOT EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'DBO.EST_PROD_PRECO_PMPF_TBL'))
BEGIN
CREATE TABLE [dbo].[EST_PROD_PRECO_PMPF_TBL](
	CD_CTR			INT NOT NULL,
	EAN				VARCHAR (50)  COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	DS_PROD			VARCHAR (100) COLLATE SQL_Latin1_General_CP1_CI_AS,
	VLR_PMPF		MONEY,
	LABORATORIO		VARCHAR (150) COLLATE SQL_Latin1_General_CP1_CI_AS,
	APRESENTACAO	VARCHAR (150) COLLATE SQL_Latin1_General_CP1_CI_AS,
	UF				VARCHAR (2)  COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	CD_USU			INT DEFAULT (''),
	DT_CAD			DATETIME,
	VLR_PMPF_ANT	MONEY,  
	DT_ULT_ALT		DATETIME,
	CD_USU_ALT		INT DEFAULT (''),
 CONSTRAINT [PK_EST_PROD_PRECO_PMPF_TBL] PRIMARY KEY CLUSTERED ([CD_CTR] ASC,	[EAN] ASC,	[UF] ASC) ON [PRIMARY])
END;

IF NOT EXISTS (SELECT 1 FROM sys.foreign_keys AS fk WHERE fk.name = 'FK_EST_PROD_PRECO_PMPF_TBL_CD_CTR' AND OBJECT_NAME(fk.parent_object_id) = 'EST_PROD_PRECO_PMPF_TBL')
BEGIN
	ALTER TABLE [dbo].[EST_PROD_PRECO_PMPF_TBL]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECO_PMPF_TBL_CD_CTR] FOREIGN KEY([CD_CTR]) REFERENCES [dbo].[EST_PROD_PRECO_PMPF] ([CD_CTR])
END





--INSERT
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'DBO.EST_PROD_PRECO_PMPF_TBL')) 
BEGIN
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'DBO.EST_PROD_PRECO_PMPF_CPL')) 
BEGIN
	IF NOT EXISTS (SELECT TOP 1 1 FROM EST_PROD_PRECO_PMPF_TBL)
	BEGIN
		INSERT EST_PROD_PRECO_PMPF_TBL (CD_CTR, EAN, DS_PROD, VLR_PMPF, LABORATORIO, APRESENTACAO, UF, CD_USU, DT_CAD, VLR_PMPF_ANT, DT_ULT_ALT, CD_USU_ALT )
		SELECT
			PMPF_CPL.CD_CTR, PMPF_CPL.EAN, EST_PROD.DS_PROD, PMPF_CPL.VLR_PMPF, PMPF_CPL.LABORATORIO, PMPF_CPL.APRESENTACAO, PMPF_CPL.UF, PMPF_CPL.CD_USU, PMPF_CPL.DT_CAD, VLR_PMPF_ANT, DT_ULT_ALT, CD_USU_ALT 
		FROM 
			EST_PROD_PRECO_PMPF_CPL PMPF_CPL
			INNER JOIN EST_PROD ON EST_PROD.CD_PROD = PMPF_CPL.CD_PROD
			INNER JOIN EST_PROD_PRECO_PMPF PMPF ON PMPF.CD_CTR = PMPF_CPL.CD_CTR AND PMPF.STS_TBL = 0
	END;
	END;
END;


--INSERT 
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'DBO.EST_PROD_PRECO_PMPF_TBL')) 
BEGIN
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'DBO.EST_PROD_PRECO_PMPF_CPL_N_ENC')) 
BEGIN
	IF NOT EXISTS (SELECT TOP 1 1 FROM EST_PROD_PRECO_PMPF_TBL)
	BEGIN
		INSERT EST_PROD_PRECO_PMPF_TBL (CD_CTR, EAN, DS_PROD, VLR_PMPF, LABORATORIO, APRESENTACAO, UF)
		SELECT
			PMPF_CPL.CD_CTR, PMPF_CPL.EAN, PMPF_CPL.DS_PROD, PMPF_CPL.VLR_PMPF, PMPF_CPL.LABORATORIO, PMPF_CPL.APRESENTACAO, PMPF_CPL.UF
		FROM 
			EST_PROD_PRECO_PMPF_CPL_N_ENC PMPF_CPL
	
	END;
	END;
END


